///************************************************************************
// *
// * \file: bdclDemo.cpp
// *
// * \version: $Id:$
// *
// * \release: $Name:$
// *
// * <brief description>.
// * <detailed description>
// * \component: bdcl - Prototype
// *
// * \author: P. Govindaraju / ADIT/SW1 / external.pgovindaraju@de.adit-jv.com
// *
// * \copyright (c) 2015 Advanced Driver Information Technology.
// * This code is developed by Advanced Driver Information Technology.
// * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
// * All rights reserved.
// *
// * \see <related items>
// *
// * \history
// *
// ***********************************************************************/
//
#include <iostream>

#include <sys/prctl.h>
#include "ServerMonitor.h"
#include <utils/SignalHandler.h>
#include <bdcl/BdclLogging.h>

#include <pthread.h>
#include <unistd.h>
#include <stdio.h>

///////////////////////ADIT
/* AOAP library header files */
#include <aoap_types.h>
#include <aoap.h>
#include <iap2_dlt_log.h>

#include <stdio.h>
#include <string.h> //for strlen
#include <signal.h>
#include <stdlib.h>
#include <unistd.h> //for sleep
#include <pthread.h> //for pthread_create
#include <sys/time.h>
#include <libudev.h>
#include <libusb-1.0/libusb.h>
#include <getopt.h> //getopt_long
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "Server.h"
#include "BdclSmoketest.h"

#include <uspi/deviceDetector.h>

#ifndef DLT_BDCL_APID
#define DLT_BDCL_APID "bdcl"
#endif


enum retunCode
{
   PASS_BDCL                 =0,
   FAIL_PHONE_NOTFOUND       =1,
   FAIL_APP_START            =2,
   FAIL_INVALID_CHANNELID    =3,
   FAIL_PLATFORM_COMPONENT   =4,
   FAIL_PHONE_NOT_RESPONDING =5,
};
/****************************************
FUNCTIONS
*****************************************/
void *cmdReceiveThread(void *arg);
void *videoReceiveThread(void *arg);
void *mediaReceiveThread(void *arg);
void *ttsReceiveThread(void *arg);
void *vrReceiveThread(void *arg);

void cmdProtocolVersionMatchStatus(S_PROTOCOL_VERSION_MATCH_SATUS* status);
void cmdMDInfro(S_MD_INFO*);
void cmdMDBTOobInfo(BTOobInfo*);
void cmdVideoEncoderInitDone(S_VIDEO_ENCODER_INIT_DONE*);
void cmdVideoEncoderFrameRateChangeDone(S_VIDEO_ENCODER_FRAME_RATE_CHANGE_DONE*);
void cmdTelStateChangeIncoming();
void cmdTelStateChangeOutGoing();
void cmdTelStateChangeIdle();
void cmdTelStateChangeInCalling();
void cmdScreenOn();
void cmdScreenOff();
void cmdScreenUserPresent();
void cmdForeground();
void cmdBackground();
void cmdGoToDeskTop();
//0x00010026
void cmdModuleStatus(S_MODULE_STATUS_LIST_MOBILE*);
//0x00010030
void cmdNaviNextTurnInfo(S_NAVI_NEXT_TURN_INFO*);
//0x00010031
void cmdCarDataSubscribe(S_VEHICLE_INFO_LIST*);
//0x00010033
void cmdCarDataSubscribeStart(S_VEHICLE_INFO_LIST*);
//0x00010034
void cmdCarDataSubscribeStop(S_VEHICLE_INFO_LIST*);
//0x00010035
void cmdMediaInfo(S_MEDIA_INFO*);
//0x00010036
void cmdMediaProgressBar(S_MEDIA_PROGRESS_BAR*);
//0x00010037
void cmdRegisterConnectException(S_CONNECTION_EXCEPTION*);
//0x00010038
void cmdRegisterRequestGoToForeground(void);
//0x00010039
void cmdRegisterUIActionSound(void);

//0x00010049
void cmdRegisterMdAuthenResponse(S_AUTHEN_RESPONSE* response);

//0x00010051
void cmdRegisterFeatureConfigRequest();

void videoDataReceive(u8 *data, u32 len);
void videoHeartBeat();
void mediaInit(S_AUDIO_INIT_PARAMETER *initParam);
void mediaNormalData(u8 *data, u32 len);
void mediaStop();
void mediaPause();
void mediaResume();
void mediaSeek();
void ttsInit(S_AUDIO_INIT_PARAMETER *initParam);
void ttsNormalData(u8 *data, u32 len);
void ttsStop();
void vrInit(S_AUDIO_INIT_PARAMETER *initParam);
void vrNormalData(u8 *data, u32 len);
void vrStop();

/******************************************
INIT PARAMETER
*******************************************/
 S_HU_PROTOCOL_VERSION huProtocolVersion={1,0};

S_VIDEO_ENCODER_INIT initVideoParam={768, 480,30};

u8 vrData[1024]={1,2,3,4,5,6,7,8,9,1,2,3,4,5,6,7,8,9,1,2,3,4,5,6,7,8,9};

S_TOUCH_ACTION touchAction={1, 12 ,34};

S_TOUCH_CAR_HARD_KEY_CODE touchCarHardKeyCode={0x00000010};//next song

//anthorization
S_AUTHEN_REQUEST authenRequest={"CarLife_1.0.0"};

S_FEATURE_CONFIG_LIST configList;
S_FEATURE_CONFIG featureConfigFocusUI;

void setFocusUIConfig(int val){
    configList.cnt=1;
    configList.pFeatureConfig=&featureConfigFocusUI;
    featureConfigFocusUI.key="FOCUS_UI";
    featureConfigFocusUI.value=val;
    featureConfigFocusUI.pNext=NULL;
}

/////////////////
LOG_DECLARE_CONTEXT(tbdcl)

using namespace adit::bdcl;

int main(int argc, char** argv)
{

    int ret;
    int opt_c;
    int autoTestTime = 0;
//////////////////// ADIT

    (void)optind;
    (void)opterr;

    // instanciate SignalHandler to set the signal mask
    SignalHandler::instance();
    // register BDCL APP ID and CONTEXT ID at logging
    LOG_REGISTER_APP(DLT_BDCL_APID, "BDCL");
    LOG_REGISTER_CONTEXT(tbdcl, "BDCL", "BDCL service");
    bdclRegisterCtxtWithDLT();
    IAP2REGISTERCTXTWITHDLT();
    std::cout<<"inside demo test"<<std::endl;

    string location = "";
    string cfgPath = "";
    string channelId = "";

    AutoSmoketest::instance().setTestMode(MANUAL); //default
    uint32_t eventMask = (adit::uspi::DD_EVENT_MASK::DD_USB_APPLE | adit::uspi::DD_EVENT_MASK::DD_USB_AOAP);

    while((opt_c = getopt(argc, argv, "h:i:s:")) != -1)
    {
        switch(opt_c)
        {
            case 'h':
                fprintf(stderr, " -s <timeout>     : Automatic smoketest mode with timeout \n");
                return 0;
            case 'i':
                channelId.assign(optarg);
                fprintf(stderr, "Passed Channel Id\n");
                break;
            case 's':
                AutoSmoketest::instance().setTestMode(AUTOMATIC); //automatic smoketest mode.
                AutoSmoketest::instance().setTestError(NODEVICE); //starting
                autoTestTime = atoi(optarg);
                eventMask = adit::uspi::DD_EVENT_MASK::DD_USB_AOAP; // set device detection to AOAP devices only
                AutoSmoketest::instance().setSmoketestTimeout(autoTestTime);
                fprintf(stderr, "bdcl demo running in automatic smoketest mode.Timeout in %d Seconds \n", autoTestTime);
                AutoSmoketest::instance().createSignalTimer(); //timerid is now valid
                AutoSmoketest::instance().startSignalTimer();
                break;
            case '?':
                if ((optopt == 'i') || (optopt == 's'))
                    fprintf(stderr, "Option -%c requires an argument \n", optopt);
                else
                    fprintf(stderr, "Unrecognised option: -%c \n", optopt);
                break;
            case ':':
                fprintf(stderr, "Option %c requires an operand\n", optopt);
                break;
            default:
                fprintf(stderr, "Unknown argument %c\n", optopt);
                break;
        }
    }
    if (channelId.length() == 0)
    {
        AutoSmoketest::instance().setTestError(INVALIDCHANNELID);
        fprintf(stderr, " -i <channelID>     : Pass valid Channel ID \n");
        fprintf (stderr,"%s \n", AutoSmoketest::instance().getErrorString().c_str());
        fprintf(stderr,"BDCL SMOKETEST FAILED !!! \n");
        return static_cast<int> (FAIL_INVALID_CHANNELID);
    }
    if (!Server::instance().init(cfgPath, channelId))
    {
        LOG_FATAL((tbdcl, "failed to start bdcl server"));
        return static_cast<int> (FAIL_APP_START);
    }

    //////////////////////////
    //register call back
    CCarLifeLib::getInstance()->cmdRegisterMDInfro(cmdMDInfro);
    CCarLifeLib::getInstance()->cmdRegisterMDBTOobInfo(cmdMDBTOobInfo);
    CCarLifeLib::getInstance()->cmdRegisterVideoEncoderFrameRateChangeDone(
            cmdVideoEncoderFrameRateChangeDone);
    CCarLifeLib::getInstance()->cmdRegisterTelStateChangeIncoming(
            cmdTelStateChangeIncoming);
    CCarLifeLib::getInstance()->cmdRegisterTelStateChangeOutGoing(
            cmdTelStateChangeOutGoing);
    CCarLifeLib::getInstance()->cmdRegisterTelStateChangeIdle(
            cmdTelStateChangeIdle);
    CCarLifeLib::getInstance()->cmdRegisterTelStateChangeInCalling(
            cmdTelStateChangeInCalling);
    CCarLifeLib::getInstance()->cmdRegisterScreenOn(cmdScreenOn);
    CCarLifeLib::getInstance()->cmdRegisterScreenOff(cmdScreenOff);
    CCarLifeLib::getInstance()->cmdRegisterScreenUserPresent(
            cmdScreenUserPresent);
    CCarLifeLib::getInstance()->cmdRegisterForeground(cmdForeground);
    CCarLifeLib::getInstance()->cmdRegisterBackground(cmdBackground);
    CCarLifeLib::getInstance()->cmdRegisterGoToDeskTop(cmdGoToDeskTop);
    //0x00010026
    CCarLifeLib::getInstance()->cmdRegisterModuleStatus(cmdModuleStatus);
    //0x00010031
    CCarLifeLib::getInstance()->cmdRegisterCarDataSubscribe(
            cmdCarDataSubscribe);
    //0x00010033
    CCarLifeLib::getInstance()->cmdRegisterCarDataSubscribeStart(
            cmdCarDataSubscribeStart);
    //0x00010034
    CCarLifeLib::getInstance()->cmdRegisterCarDataSubscribeStop(
            cmdCarDataSubscribeStop);
    //0x00010035
    CCarLifeLib::getInstance()->cmdRegisterMediaInfo(cmdMediaInfo);
    //0x00010036
    CCarLifeLib::getInstance()->cmdRegisterMediaProgressBar(
            cmdMediaProgressBar);
    //0x00010037
    CCarLifeLib::getInstance()->cmdRegisterConnectException(
            cmdRegisterConnectException);
    //0x00010038
    CCarLifeLib::getInstance()->cmdRegisterRequestGoToForeground(
            cmdRegisterRequestGoToForeground);
    //0x00010039
    CCarLifeLib::getInstance()->cmdRegisterUIActionSound(
            cmdRegisterUIActionSound);


    // the monitor is sending switching and session requests to the server
    ServerMonitor monitor;
    // register SIGINT so that monitor and server can be stopped
    SignalHandler::instance().registerForSIGINT(&Server::instance());
    SignalHandler::instance().registerForSIGINT(&monitor);
    if (!monitor.start(eventMask))
    {
        LOG_FATAL((tbdcl, "failed to start Android device monitor"));
        return static_cast<int> (FAIL_APP_START);
    }

    LOG_INFO((tbdcl, "enter main loop"));

    prctl(PR_SET_NAME, "bdcl-demo-main", 0, 0, 0);
    monitor.waitForExit();
    LOG_INFO((tbdcl, "stop main loop"));

    LOG_INFO((tbdcl, "DESTROY BAIDU SESSION !!!"));
    Server::instance().destroySession(); //only baidu session

    // stop the monitor
    monitor.stop();

    // signal handler MUST be unregistered before they go out of scope
    SignalHandler::instance().unregister(&monitor);
    SignalHandler::instance().unregister(&Server::instance());

    Server::instance().cleanUp();

    if(AutoSmoketest::instance().getTestError() == NOERROR)
    {
        ret = static_cast<int> (PASS_BDCL);
        LOG_INFO((tbdcl, "BDCL SMOKETEST PASSED !!!"));
        //for Console
        fprintf (stderr,"%s \n", AutoSmoketest::instance().getErrorString().c_str());
        fprintf(stderr, "BDCL SMOKETEST PASSED !!! \n");
    }
    else
    {
        if(AutoSmoketest::instance().getTestError() == GSTINTERNAL)
        {
            ret = static_cast<int> (FAIL_PLATFORM_COMPONENT);
        }
        else if(AutoSmoketest::instance().getTestError() == NODEVICE)
        {
            ret = static_cast<int> (FAIL_PHONE_NOTFOUND);
        }
        else if(AutoSmoketest::instance().getTestError() == PHONENOTRESPONDING)
        {
            ret = static_cast<int> (FAIL_PHONE_NOT_RESPONDING);
        }
        LOG_INFO((tbdcl, "BDCL SMOKETEST FAILED !!!"));
        //for console
        fprintf (stderr,"%s \n", AutoSmoketest::instance().getErrorString().c_str());
        fprintf(stderr,"BDCL SMOKETEST FAILED !!! \n");
    }

    IAP2DEREGISTERCTXTWITHDLT();
    bdclDeRegisterCtxtWithDLT();
    // unregister all bdcl DLT context
    LOG_UNREGISTER_CONTEXT(tbdcl);
    LOG_UNREGISTER_APP();
    return ret;
}


void cmdMDInfro(S_MD_INFO* mdInfro){
    cout<<"cmdMDInfro() is invoked"<<endl;
    cout<<"\tos: "<<mdInfro->os<<endl;
    cout<<"\tboard: "<<mdInfro->board<<endl;
    cout<<"\tbootloader: "<<mdInfro->bootloader<<endl;
    cout<<"\tbrand: "<<mdInfro->brand<<endl;
    cout<<"\tcpu_abi: "<<mdInfro->cpu_abi<<endl;
    cout<<"\tcpu_abi2: "<<mdInfro->cpu_abi2<<endl;
    cout<<"\tdevice: "<<mdInfro->device<<endl;
    cout<<"\tdisplay: "<<mdInfro->display<<endl;
    cout<<"\tfingerprint: "<<mdInfro->fingerprint<<endl;
    cout<<"\thardware: "<<mdInfro->hardware<<endl;
    cout<<"\thost: "<<mdInfro->host<<endl;
    cout<<"\tcid: "<<mdInfro->cid<<endl;
    cout<<"\tmanufacturer: "<<mdInfro->manufacturer<<endl;
    cout<<"\tmodel: "<<mdInfro->model<<endl;
    cout<<"\tproduct: "<<mdInfro->product<<endl;
    cout<<"\tserial: "<<mdInfro->serial<<endl;
    cout<<"\tcodename: "<<mdInfro->codename<<endl;
    cout<<"\tincremental: "<<mdInfro->incremental<<endl;
    cout<<"\trelease: "<<mdInfro->release<<endl;
    cout<<"\tsdk: "<<mdInfro->sdk<<endl;
    cout<<"\tsdk_int: "<<mdInfro->sdk_int<<endl;
    cout<<"\tbtaddress: "<<mdInfro->btaddress<<endl;
    cout<<"\tbtname: "<<mdInfro->btname<<endl;
}

void cmdMDBTOobInfo(BTOobInfo* info){
    cout<<"cmdMDBTOobInfo() is invoked"<<endl;
    cout<<"/taddress: "<<info->address<<endl;
    cout<<"/tpassKey: "<<info->passKey<<endl;
    cout<<"/thash: "<<info->hash<<endl;
    cout<<"/trandomizer: "<<info->randomizer<<endl;
    cout<<"/tuuid: "<<info->uuid<<endl;
    cout<<"/tname: "<<info->name<<endl;
    cout<<"/tstatus: "<<info->status<<endl;
}

void cmdVideoEncoderInitDone(S_VIDEO_ENCODER_INIT_DONE* videoEncoderInitDone){
    cout<<"cmdVideoEncoderInitDone() is invoked"<<endl;
    cout<<"\twidth: "<<videoEncoderInitDone->width<<endl;
    cout<<"\theight: "<<videoEncoderInitDone->height<<endl;
    cout<<"\tframeRate: "<<videoEncoderInitDone->frameRate<<endl;
}

void cmdVideoEncoderFrameRateChangeDone(S_VIDEO_ENCODER_FRAME_RATE_CHANGE_DONE* videoEncoderFrameRateChangeDone){
    cout<<"cmdVideoEncoderFrameRateChangeDone() is invoked"<<endl;
    cout<<"\tframeRate: "<<videoEncoderFrameRateChangeDone->frameRate<<endl;
}

void cmdTelStateChangeIncoming(){
    cout<<"cmdTelStateChangeIncoming() is invoked"<<endl;
}

void cmdTelStateChangeOutGoing(){
    cout<<"cmdTelStateChangeOutGoing() is invoked"<<endl;
}

void cmdTelStateChangeIdle(){
    cout<<"cmdTelStateChangeIdle() is invoked"<<endl;
}
void cmdTelStateChangeInCalling(){
    cout<<"cmdTelStateChangeInCalling() is invoked"<<endl;
}

void cmdScreenOn(){
    cout<<"cmdScreenOn() is invoked"<<endl;
}
void cmdScreenOff(){
    cout<<"cmdScreenOff() is invoked"<<endl;
}
void cmdScreenUserPresent(){
    cout<<"cmdScreenUserPresent() is invoked"<<endl;
}

void cmdForeground(){
    cout<<"cmdForeground() is invoked"<<endl;
}

void cmdBackground(){
    cout<<"cmdBackground() is invoked"<<endl;
}

void cmdGoToDeskTop(){
    cout<<"cmdGoToDeskTop() is invoked"<<endl;
}

//0x00010026
void cmdModuleStatus(S_MODULE_STATUS_LIST_MOBILE*){
    cout<<"cmdModuleStatus is invoked"<<endl;
}

//0x00010031
void cmdCarDataSubscribe(S_VEHICLE_INFO_LIST*){
    cout<<"cmdCarDataSubscribe is invoked"<<endl;
}
//0x00010033
void cmdCarDataSubscribeStart(S_VEHICLE_INFO_LIST*){
    cout<<"cmdCarDataSubscribeStart is invoked"<<endl;
}

//0x00010034
void cmdCarDataSubscribeStop(S_VEHICLE_INFO_LIST*){
    cout<<"cmdCarDataSubscribeStop is invoked"<<endl;
}

//0x00010035
void cmdMediaInfo(S_MEDIA_INFO* info){
    cout<<"cmdMediaInfo is invoked"<<endl;

    cout<<"source= "<<info->source<<endl;
    cout<<"song= "<<info->song<<endl;
    cout<<"artist= "<<info->artist<<endl;
    cout<<"album= "<<info->album<<endl;
    //cout<<"albumArt= "<<info->albumArt<<endl;
    cout<<"duration= "<<info->duration<<endl;
    cout<<"playlistNum= "<<info->playlistNum<<endl;
    cout<<"songId= "<<info->songId<<endl;
    cout<<"mode= "<<info->mode<<endl;


}

//0x00010036
void cmdMediaProgressBar(S_MEDIA_PROGRESS_BAR*){
    cout<<"cmdMediaProgressBar is invoked"<<endl;
}

//0x00010037
void cmdRegisterConnectException(S_CONNECTION_EXCEPTION*){
    cout<<"cmdRegisterConnectException is invoked"<<endl;
}

//0x00010038
void cmdRegisterRequestGoToForeground(void){
    cout<<"cmdRegisterRequestGoToForeground is invoked"<<endl;
}

//0x00010039
void cmdRegisterUIActionSound(void){
    cout<<"cmdRegisterUIActionSound is invoked"<<endl;
}

//0x00010049
void cmdRegisterMdAuthenResponse(S_AUTHEN_RESPONSE* response){
    cout<<"cmdRegisterMdAuthenResponse is invoked"<<endl;
    cout<<"encryptValue= "<<response->encryptValue<<endl;
}

//0x00010051
void cmdRegisterFeatureConfigRequest(){
    cout<<"cmdRegisterFeatureConfigRequest is invoked"<<endl;

    setFocusUIConfig(1);
    //0x00018052
    CCarLifeLib::getInstance()->cmdFeatureConfigResponse(&configList);
}

void videoHeartBeat(){
    cout<<"videoHeartBeat() is invoked"<<endl;
    cout<<"\tvideo heart beat received!";
}


//tts channel callback functions
void ttsInit(S_AUDIO_INIT_PARAMETER *initParam){
    cout<<"ttsInit() is invoked"<<endl;
    cout<<"\tsampleRate: "<<initParam->sampleRate<<endl;
    cout<<"\tchannelConfig: "<<initParam->channelConfig<<endl;
    cout<<"\tsampleFormat: "<<initParam->sampleFormat<<endl;
}

void ttsNormalData(u8 *data, u32 len){
    cout<<"ttsNormalData() is invoked"<<endl;
    cout<<"\treceive tts data: "<<len<<" bytes"<<endl;
/*
    for(int i=0;i<len;i++){
        cout<<data[i]<<" ";
    }

    cout<<endl;
*/
}

void ttsStop(){
    cout<<"ttsStop() is invoked"<<endl;
    cout<<"\ttts stop status received!"<<endl;
}


//vr channel callback functions
void vrInit(S_AUDIO_INIT_PARAMETER *initParam){
    cout<<"vrInit() is invoked"<<endl;
    cout<<"\tsampleRate: "<<initParam->sampleRate<<endl;
    cout<<"\tchannelConfig: "<<initParam->channelConfig<<endl;
    cout<<"\tsampleFormat: "<<initParam->sampleFormat<<endl;
}

void vrNormalData(u8 *data, u32 len){
    cout<<"vrNormalData() is invoked"<<endl;
    cout<<"\treceive vr data: "<<len<<" bytes"<<endl;
/*
    for(int i=0;i<len;i++){
        cout<<data[i]<<" ";
    }

    cout<<endl;
*/
}

void vrStop(){
    cout<<"vrStop() is invoked"<<endl;
    cout<<"\tvr stop status received!"<<endl;
}

